<!doctype html>
<html class="no-js" lang="zxx">
<?php include('header.php');?>
<body>
    <header>
        <?php include('menu.php');?>
    </header>
    <div class="featured_candidates_area candidate_page_padding">
        <div class="container">
            <div class="row">
				<div class="col-lg-2"></div>
				<div class="col-lg-8">
					<div class="header">
						<h1 class="header__title"><i class="fas fa-bomb"></i> Mines</h1>
					</div>
					<div class="content">
						<div class="game_container no-select">
							<div class="game_main">			
								<div class="row">
									<div class="col-lg-12">
										<div class="input_container">
											<div class="row">
												<div class="col-12 bet_amount">
													<div class="input_label">Bet Amount</div>
													<div class="input_group">
														<i style="font-size: 18px; color: #FF9800" class="fab fa-bitcoin addon"></i>
														<input type="text" id="bet_amount" value="0.00000100">
													</div>
													<p id="bet_double">2X</p>
													<p id="bet_half">1/2</p>
												</div>
												<div class="col-6">
													<div class="input_label">Mines</div>
													<?php if(sizeof($mines) > 0):?>
													<div class="input_group no_pad disabled">
														<select id="num_mines" disabled="disabled">
															<?php for($i = 1; $i <= 24; $i++):?>
															<option value="<?=$i?>" <?php if($i == sizeof($mines)) echo 'selected';?>><?=$i?></option>
															<?php endfor?>
														</select>
													</div>
													<?php else :?>
													<div class="input_group no_pad">
														<select id="num_mines">
															<?php for($i = 1; $i <= 24; $i++):?>
															<option value="<?=$i?>"><?=$i?></option>
															<?php endfor?>
														</select>
													</div>
													<?php endif?>				
												</div>
												<div class="col-6">
													<div class="input_label">Gems</div>
													<div class="input_group">
														<?php if(sizeof($mines) > 0):?>
														<input type="text" id="remaining_gems" value="<?php echo (25 - sizeof($tiles) - sizeof($mines));?>" readonly="readonly">
														<?php else :?>
														<input type="text" id="remaining_gems" value="24" readonly="readonly">
														<?php endif?>
														<i class="fas fa-gem addon"></i>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-12">
										<div class="input_container">
											<div class="row">
												<div class="col-md-6 col-12">
													<div class="input_label" id="next_tile_profit_label">Profit On Next Tile</div>
													<div class="input_group">
														<i style="font-size: 18px; color: #FF9800" class="fab fa-bitcoin addon"></i>
														<input type="text" id="next_tile_profit" value="0.00000000" readonly="readonly">
													</div>
												</div>
												<div class="col-md-6 col-12">
													<div class="input_label" id="total_profit_label">Total Profit</div>
													<div class="input_group">
														<i style="font-size: 18px; color: #FF9800" class="fab fa-bitcoin addon"></i>
														<input type="text" id="total_profit" value="0.00000000" readonly="readonly">
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-12">
										<div class="mine_board">
											<?php for($i = 0; $i < 25; $i++):?>
											<?php if(sizeof($mines) == 0):?>
											<div class="tile disabled" id="tile_<?=$i?>">
												<div class="front" tile_id="<?=$i?>"></div>
												<div class="back"></div>
											</div>
											<?php elseif(in_array($i, $tiles)):?>
											<div class="tile disabled" id="tile_<?=$i?>">
												<div class="front hide" tile_id="<?=$i?>"></div>
												<div class="back"><img src="<?=base_url()?>img/games/diamond.svg" class="show"></div>
											</div>
											<?php else:?>
											<div class="tile" id="tile_<?=$i?>">
												<div class="front" tile_id="<?=$i?>"></div>
												<div class="back"></div>
											</div>
											<?php endif?>
											<?php endfor?>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-12" style="text-align: center;">
										<?php if(sizeof($mines) == 0):?>
										<button class="btn btn-success bet_btn" id="bet_btn">BET</button>
										<button class="btn btn-danger bet_btn" id="cashout_btn" style="display: none">CASHOUT</button>
										<?php else:?>
										<button class="btn btn-success bet_btn" id="bet_btn" style="display: none">BET</button>
										<button class="btn btn-danger bet_btn" id="cashout_btn">CASHOUT</button>
										<?php endif?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="gameBar_wrap">
					<ul class="gameBar_main clear">
						<li class="left gameBar_li">
							<div class="footer_wrap"><i class="fas fa-book"></i></div>
							<span class="footer_text">Rules</span>
						</li>
						<li class="left gameBar_li">
							<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
							<span class="footer_text">Fairness</span>
						</li>
						<li class="left gameBar_li">
							<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
							<span class="footer_text">Hotkeys</span>
						</li>
					</ul>
				</div>
				<div class="bets_nav">
					<ul class="clear">
						<li class="left">MY BETS</li>
						<li class="left li_active">ALL BETS</li>
						<li class="left">HIGH WINS</li>
					</ul>
				</div>
				<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; ">
					<table class="table table-striped bets_table">
					  <tbody>
						<thead>
							<tr>
								<td scope="col">BetID</td>
								<td scope="col">Game</td>
								<td scope="col">User</td>
								<td scope="col">Time</td>
								<td scope="col">Bet</td>
								<td scope="col">Payout</td>
								<td scope="col">Profit</td>
							</tr>
						</thead>
						<?php for($i = 0; $i < 20; $i++):?>
						<tr>
							<td><a href="#" style="color: #03a9f4">10148233041</a></td>
							<td><i class="fas fa-bomb"></i> Mines</td>
							<td>Dassark</td>
							<td>9:30 AM</td>
							<td>0.00000900</td>
							<td>2x</td>
							<td><a href="#" style="color: #8bc34a">0.00000900</a></td>
						</tr>
						<?php endfor?>
					  </tbody>
					</table>
				</div>
				<div class="col-lg-2"></div>
			</div>
		 </div>
	</div>
	
	

    <?php include('footer.php');?>
	<script>
		var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
		var MIN_BET_AMOUNT = 0.000001;
		var MAX_BET_AMOUNT = 0.05;
		var MIN_MINES = 1;
		var MAX_MINES = 24;
		var TOTAL_TILES = 25;
		var MAGIC_NUMBER = 0.97;
		
		function calc_profit() {
			var num_mines = parseInt($('#num_mines').val());
			var total_gems = TOTAL_TILES - num_mines;
			var remaining_gems = parseInt($('#remaining_gems').val());
			var picked_gems = total_gems - remaining_gems;
			var current_payout = 1;
			var next_tile_payout = parseFloat(MAGIC_NUMBER * TOTAL_TILES / total_gems).toFixed(2);
			var current_profit = 0;
			var next_tile_profit = 0;
			var bet_amount = parseFloat($('#bet_amount').val());
			var i = 0;
			for(i = 0; i < picked_gems; i++) {
				current_payout = next_tile_payout;	
				next_tile_payout = parseFloat(next_tile_payout * parseFloat(MAGIC_NUMBER * (TOTAL_TILES - i) / (total_gems - i)));
			}
			current_payout = parseFloat(current_payout).toFixed(2);
			next_tile_payout = parseFloat(next_tile_payout).toFixed(2);
			current_profit = parseFloat((current_payout - 1) * bet_amount).toFixed(8);
			next_tile_profit = parseFloat((next_tile_payout - 1) * bet_amount).toFixed(8);
			$('#next_tile_profit_label').html('Profit On Next Tile ('+next_tile_payout+'×)');
			$('#total_profit_label').html('Total Profit ('+current_payout+'×)');
			$('#total_profit').val(current_profit);
			$('#next_tile_profit').val(next_tile_profit);
		}
		
		
		
		function set_bet_double_amount() {			
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount *= 2;
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
			calc_profit();
		}
		
		function set_bet_half_amount() {
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount /= 2;
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
			calc_profit();
		}
		
		function change_bet_amount() {
			var bet_amount = parseFloat($('#bet_amount').val());
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
			}
			setTimeout(function() {
				$('#bet_amount').val(bet_amount.toFixed(8));
				calc_profit();
			}, 100);
		}
		
		function change_num_mines() {
			var num_mines = parseInt($('#num_mines').val());
			var remaining_gems = 0;
			if(num_mines < MIN_MINES || isNaN(num_mines)) {
				num_mines = MIN_BET_AMOUNT;
			}
			if(num_mines > MAX_MINES) {
				num_mines = MAX_MINES;
			}
			remaining_gems = TOTAL_TILES - num_mines;
			setTimeout(function() {
				$('#num_mines').val(num_mines);
				$('#remaining_gems').val(remaining_gems);
				calc_profit();
			}, 100);
		}
		
		function process_bet_game_mines() {
			var bet_amount = parseFloat($('#bet_amount').val());
			var num_mines = parseInt($('#num_mines').val());
			setTimeout(function() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=bet_game_mines&bet_amount="+bet_amount+"&num_mines="+num_mines,
					error: function(){
						Swal.fire('Error!','Request timed out. Please try again!','error');
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							Swal.fire('Error!',obj.mes,'error');
						} else {
							$("#bet_btn").hide();
							$("#cashout_btn").show();
							$('#num_mines').prop('disabled', true);
							$("#num_mines").parent().addClass('disabled');
							$("#num_mines").parent().find('.nice-select').addClass('disabled');
							$(".game_main .mine_board .tile").removeClass('disabled');
							$(".game_main .mine_board .tile .front").removeClass('hide');
							$(".game_main .mine_board .tile .back").removeClass('revealed');
							$(".game_main .mine_board .tile .back").html('');
							$('.user_balance div').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8)+' BTC');
						}		
					}
				});
			}, 100);
		}
		
		function process_select_tile_game_mines() {
			if($(this).parent().hasClass('disabled')) {
				Swal.fire('Error!','Please click bet first!','error');
			} else {
				var front = $(this);
				var back = $(this).parent().find('.back');
				var tile_id =  $(this).attr('tile_id');
				front.addClass('focus');
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=select_tile_game_mines&tile_id="+tile_id,
						error: function(){
							Swal.fire('Error!','Request timed out. Please try again!','error');
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								Swal.fire('Error!',obj.mes,'error');
							} else {
								front.removeClass('focus');
								front.addClass('hide');
								if(obj.type == 'gem') {
									var remaining_gems = parseInt($('#remaining_gems').val());
									$('#remaining_gems').val(remaining_gems-1);
									calc_profit();
									back.html('<img src="<?=base_url()?>img/games/diamond.svg" class="show">');
									var mines = obj.mines;
									if(mines != '') {
										for(i = 0; i < TOTAL_TILES; i++) {
											if($('#tile_'+i+' .back').html() == '') {
												$('#tile_'+i+' .back').parent().find('.front').addClass('hide');
												$('#tile_'+i+' .back').addClass('revealed');
												if(mines.includes(i)) {
													$('#tile_'+i+' .back').html('<img src="<?=base_url()?>img/games/bomb.svg" class="show">');
												} else {
													$('#tile_'+i+' .back').html('<img src="<?=base_url()?>img/games/diamond.svg" class="show">');
												}
											}
										}
										$('.user_balance div').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8)+' BTC');
										$("#bet_btn").show();
										$("#cashout_btn").hide();
										$("#num_mines").attr('disabled', false);
										$("#num_mines").parent().removeClass('disabled');
										$("#num_mines").parent().find('.nice-select').removeClass('disabled');
										change_num_mines();
										calc_profit();
									}
								} else {
									back.html('<img src="<?=base_url()?>img/games/bomb.svg" class="show">');
									var mines = obj.mines;
									for(i = 0; i < TOTAL_TILES; i++) {
										if($('#tile_'+i+' .back').html() == '') {
											$('#tile_'+i+' .back').parent().find('.front').addClass('hide');
											$('#tile_'+i+' .back').addClass('revealed');
											if(mines.includes(i)) {
												$('#tile_'+i+' .back').html('<img src="<?=base_url()?>img/games/bomb.svg" class="show">');
											} else {
												$('#tile_'+i+' .back').html('<img src="<?=base_url()?>img/games/diamond.svg" class="show">');
											}
										}
									}
									$('.user_balance div').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8)+' BTC');
									$("#bet_btn").show();
									$("#cashout_btn").hide();
									$("#num_mines").attr('disabled', false);
									$("#num_mines").parent().removeClass('disabled');
									$("#num_mines").parent().find('.nice-select').removeClass('disabled');
									change_num_mines();
									calc_profit();
								}
							}
						}
					});			
				}, 200);
			}
		}
		
		function process_cashout_game_mines() {
			setTimeout(function() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=cashout_game_mines",
					error: function(){
						Swal.fire('Error!','Request timed out. Please try again!','error');
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							Swal.fire('Error!',obj.mes,'error');
						} else {
							var mines = obj.mines;
							for(i = 0; i < TOTAL_TILES; i++) {
								if($('#tile_'+i+' .back').html() == '') {
									$('#tile_'+i+' .back').parent().find('.front').addClass('hide');
									$('#tile_'+i+' .back').addClass('revealed');
									if(mines.includes(i)) {
										$('#tile_'+i+' .back').html('<img src="<?=base_url()?>img/games/bomb.svg" class="show">');
									} else {
										$('#tile_'+i+' .back').html('<img src="<?=base_url()?>img/games/diamond.svg" class="show">');
									}
								}
							}
							$('.user_balance div').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8)+' BTC');
							$("#bet_btn").show();
							$("#cashout_btn").hide();
							$("#num_mines").attr('disabled', false);
							$("#num_mines").parent().removeClass('disabled');
							$("#num_mines").parent().find('.nice-select').removeClass('disabled');
							change_num_mines();
							calc_profit();
						}
					}
				});			
			}, 100);
		}
		
		
		
		$(document).ready(function() {
			$("#bet_double").on("click", set_bet_double_amount);
			$("#bet_half").on("click", set_bet_half_amount);
			$("#bet_amount").on("change", change_bet_amount);
			$("#num_mines").on("change", change_num_mines);
			$("#bet_btn").on("click", process_bet_game_mines);
			$(".mine_board .tile .front").on("click", process_select_tile_game_mines);
			$("#cashout_btn").on("click", process_cashout_game_mines);
			calc_profit();
		})

	</script>
</body>
</html>